#include <iostream>
#include <vector>
#include <queue>

using namespace std;

queue<int> dodavanje(vector<vector<int>> pecina, int n, int start, int max_dubina) {
	queue<int> res;

	vector<int> poseceni(n + 1);
	vector<int> nivoi(n + 1);
	queue <int> cekanje;
	for (int i = 0; i < n; i++) {
		poseceni[i] = 0;
	}
	nivoi[start] = 0;
	poseceni[start] = 1;
	cekanje.push(start);
	while (!cekanje.empty()) 
	{

		int c = cekanje.front();
		cekanje.pop();
		for (vector<int> ::iterator it = pecina[c].begin(); it != pecina[c].end(); it++) {
			if (poseceni[*it] == 0)
			{
				poseceni[*it] = 1;
				nivoi[*it] = nivoi[c] + 1;
				cekanje.push(*it);
			}
		}
	}
	for (int i = 0; i <= n; i++) {
		if (nivoi[i] <= max_dubina) {
			res.push(i);
		}
	}
	return res;
}

int main()
{
	int N;
	cin >> N;
	vector<vector<int>> pecina(N + 1);
	for (int i = 0; i < N - 1; i++) {
		int u, v;
		cin >> u >> v;
		pecina[v].push_back(u);
	}
	pecina[1].push_back(0);

	vector<bool> platforme(N + 1);
	platforme[0] = true;
	for (int i = 1; i <= N; i++) {
		bool x;
		cin >> x;
		platforme[i] = x;
	}
	vector<int> menjanje(N + 1);
	for (int i = 1; i <= N; i++) {
		int x;
		cin >> x;
		if (x == 0) {
			menjanje[i] = -1;
		}
		else {
			menjanje[i] = x;
		}
	}

	for (int z = 1; z <= N; z++) {
		if (menjanje[z] != -1) {
			if (platforme[menjanje[z]] == true) {
				platforme[menjanje[z]] = false;
			}
			else {
				platforme[menjanje[z]] = true;
			}
		}

		queue<int> q = dodavanje(pecina, N, z, z);
		while (!q.empty()) {
			pecina[z].push_back(q.front());
			q.pop();
		}

		vector<int> razdaljine(pecina.size());
		queue<int> cekanje;

		for (int i = 0; i < pecina.size(); i++) {
			razdaljine[i] = 1000000;
		}
		razdaljine[z] = 0;
		cekanje.push(z);

		while (!cekanje.empty()) {
			int trenutni = cekanje.front();
			cekanje.pop();

			for (vector<int>::iterator it = pecina[trenutni].begin(); it != pecina[trenutni].end(); it++) {
				if (platforme[*it] == false) {
					continue;
				}
				if (razdaljine[trenutni] + 1 < razdaljine[*it]) {
					razdaljine[*it] = razdaljine[trenutni] + 1;
					cekanje.push(*it);
				}
			}
		}

		if (razdaljine[0] == 1000000) {
			cout << -1 << " ";
		}
		else {
			cout << razdaljine[0] << " ";
		}
		
	}
	
}